Option Strict Off
Option Explicit On
Module GPIB
    ' CEC IEEE-488 subroutines
    ' for use with CEC interface cards
    ' Copyright (C) 1995, Capital Equipment Corporation
    ' Customers may use this code in their application
    ' programs which run with CEC interface cards.
    ' All other rights reserved.
    ' For VISUAL BASIC 4.0 and later versions
    '
    ' revisions:
    '       4/23/96 - change integer to long for 32-bit routines
    '       1/28/97 - fix declaration of SetInputEOS routine for 32-bit
    '       5/97    - added new routines for CEC488 v5
    '       2/02    - added IEEEFIFO constant
    '
    '       8/02    - modified for use with VB.NET
    '           MOSTLY changed by the automatic upgrade feature of VB.NET
    '             (the comments added by VB.NET are left in)
    '             The only additional changes are to comment out lines with fatal errors (in tarray/rarray)
    '           NOTE: tarray and rarray are NOT accessible from VB.NET at this time
    '       8/02    - modified for use with VB.NET
    '           Commented references to 16-bit IEEE488 routines in Declare statments and IF..THEN..ELSE statements

    '----------------
    Public Const IEEEListener As Short = 0
    Public Const IEEE488SD As Short = 1
    Public Const IEEEDMA As Short = 2
    Public Const IEEEFIFO As Short = 3
    Public Const IEEEIOBASE As Short = 100
    Public Const IEEETIMEOUT As Short = 200
    Public Const IEEEINPUTEOS As Short = 201
    Public Const IEEEOUTPUTEOS1 As Short = 202
    Public Const IEEEOUTPUTEOS2 As Short = 203
    Public Const IEEEBOARDSELECT As Short = 204
    Public Const IEEEDMACHANNEL As Short = 205

    '#If Win32 Then
    '----------------------------------------------------------------------------
    ' 32-bit versions of IEEE488 routines
    '----------------------------------------------------------------------------
    Declare Sub initialize Lib "IEEE_32M.DLL" Alias "_ieee_initialize@8" (ByVal addr As Integer, ByVal level As Integer)
    Declare Sub IEtrans Lib "IEEE_32M.DLL" Alias "_ieee_transmit@12" (ByVal cmd As String, ByVal l As Integer, ByRef status As Integer)
    Declare Sub IEreceive Lib "IEEE_32M.DLL" Alias "_ieee_receive@16" (ByVal r As String, ByVal maxlen As Integer, ByRef l As Integer, ByRef status As Integer)
    Declare Sub IEsend Lib "IEEE_32M.DLL" Alias "_ieee_send@16" (ByVal addr As Integer, ByVal s As String, ByVal l As Integer, ByRef status As Integer)
    Declare Sub IEenter Lib "IEEE_32M.DLL" Alias "_ieee_enter@20" (ByVal r As String, ByVal maxlen As Integer, ByRef l As Integer, ByVal addr As Integer, ByRef status As Integer)
    Declare Sub IEspoll Lib "IEEE_32M.DLL" Alias "_ieee_spoll@12" (ByVal addr As Integer, ByRef poll As Integer, ByRef status As Integer)
    Declare Sub IEppoll Lib "IEEE_32M.DLL" Alias "_ieee_ppoll@4" (ByRef poll As Integer)
    'UPGRADE_ISSUE: Declaring a parameter 'As Any' is not supported. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1016"'
    '	Declare Sub IEtarray Lib "IEEE_32M.DLL"  Alias "_ieee_tarray@16"(ByRef d As Any, ByVal count As Integer, ByVal eoi As Integer, ByRef status As Integer)
    'UPGRADE_ISSUE: Declaring a parameter 'As Any' is not supported. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1016"'
    '	Declare Sub IErarray Lib "IEEE_32M.DLL"  Alias "_ieee_rarray@16"(ByRef d As Any, ByVal count As Integer, ByRef l As Integer, ByRef status As Integer)
    Declare Function srq Lib "IEEE_32M.DLL" Alias "_ieee_srq@0" () As Integer
    Declare Sub setport Lib "IEEE_32M.DLL" Alias "_ieee_setport@8" (ByVal board As Integer, ByVal port As Integer)
    Declare Sub boardselect Lib "IEEE_32M.DLL" Alias "_ieee_boardselect@4" (ByVal board As Integer)
    Declare Sub dmachannel Lib "IEEE_32M.DLL" Alias "_ieee_dmachannel@4" (ByVal chan As Integer)
    Declare Sub settimeout Lib "IEEE_32M.DLL" Alias "_ieee_settimeout@4" (ByVal msec As Integer)
    Declare Sub setoutputEOS Lib "IEEE_32M.DLL" Alias "_ieee_setoutputEOS@8" (ByVal c1 As Integer, ByVal c2 As Integer)
    Declare Sub setinputEOS Lib "IEEE_32M.DLL" Alias "_ieee_setinputEOS@4" (ByVal c As Integer)
    Declare Sub Enable488EX Lib "IEEE_32M.DLL" Alias "_ieee_enable_488ex@4" (ByVal e As Integer)
    Declare Sub Enable488SD Lib "IEEE_32M.DLL" Alias "_ieee_enable_488sd@8" (ByVal e As Integer, ByVal t As Integer)
    Declare Function ListenerPresent Lib "IEEE_32M.DLL" Alias "_ieee_listener_present@4" (ByVal a As Integer) As Integer
    Declare Function GpibBoardPresent Lib "IEEE_32M.DLL" Alias "_ieee_board_present@0" () As Integer
    Declare Function GPIBFeature Lib "IEEE_32M.DLL" Alias "_ieee_feature@4" (ByVal f As Integer) As Integer
    '#Else
    'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
    '----------------------------------------------------------------------------
    ' 16-bit versions of IEEE488 routines
    '----------------------------------------------------------------------------
    '   Declare Sub initialize Lib "win488.dll" Alias "IEEE488_INITIALIZE" (ByVal addr As Integer, ByVal level As Integer)
    '  Declare Sub IEtrans Lib "win488.dll" Alias "IEEE488_TRANSMIT" (ByVal cmd As String, ByVal l As Integer, ByVal status As Integer)
    ' Declare Sub IEreceive Lib "win488.dll" Alias "IEEE488_RECEIVE" (ByVal r As String, ByVal maxlen As Integer, ByVal l As Integer, ByVal status As Integer)
    'Declare Sub IEsend Lib "win488.dll" Alias "IEEE488_SEND" (ByVal addr As Integer, ByVal s As String, ByVal l As Integer, ByVal status As Integer)
    'Declare Sub IEenter Lib "win488.dll" Alias "IEEE488_ENTER" (ByVal r As String, ByVal maxlen As Integer, ByVal l As Integer, ByVal addr As Integer, ByVal status As Integer)
    'Declare Sub IEspoll Lib "win488.dll" Alias "IEEE488_SPOLL" (ByVal addr As Integer, ByVal poll As Integer, ByVal status As Integer)
    'Declare Sub IEppoll Lib "win488.dll" Alias "IEEE488_PPOLL" (ByVal poll As Integer)
    'Declare Sub IEtarray Lib "win488.dll" Alias "IEEE488_TARRAY" (d As Any, ByVal count As Integer, ByVal eoi As Integer, status As Integer)
    'Declare Sub IErarray Lib "win488.dll" Alias "IEEE488_RARRAY" (d As Any, ByVal count As Integer, l As Integer, status As Integer)
    'Declare Function srq Lib "win488.dll" Alias "IEEE488_SRQ" () As Integer
    'Declare Sub setport Lib "win488.dll" Alias "IEEE488_SETPORT" (ByVal board As Integer, ByVal port As Integer)
    'Declare Sub boardselect Lib "win488.dll" Alias "IEEE488_BOARDSELECT" (ByVal board As Integer)
    'Declare Sub dmachannel Lib "win488.dll" Alias "IEEE488_DMACHANNEL" (ByVal chan As Integer)
    'Declare Sub settimeout Lib "win488.dll" Alias "IEEE488_SETTIMEOUT" (ByVal msec As Integer)
    'Declare Sub setoutputEOS Lib "win488.dll" Alias "IEEE488_SETOUTPUTEOS" (ByVal c1 As Integer, ByVal c2 As Integer)
    'Declare Sub setinputEOS Lib "win488.dll" Alias "IEEE488_SETINPUTEOS" (ByVal c As Integer)
    'Declare Sub Enable488EX Lib "win488.dll" Alias "IEEE488_ENABLE_488EX" (ByVal e As Integer)
    'Declare Sub Enable488SD Lib "win488.dll" Alias "IEEE488_ENABLE_488SD" (ByVal e As Integer, ByVal t As Integer)
    'Declare Function ListenerPresent Lib "win488.dll" Alias "IEEE488_LISTENER_PRESENT" (ByVal a As Integer) As Integer
    'Declare Function GpibBoardPresent Lib "win488.dll" Alias "IEEE488_BOARD_PRESENT" () As Integer
    'Declare Function GPIBFeature Lib "win488.dll" Alias "IEEE488_FEATURE" (ByVal f As Integer) As Integer
    '#End If
    '-------------------------------------------------------
    Sub enter(ByRef r As String, ByRef maxlen As Short, ByRef l As Short, ByRef addr As Short, ByRef status As Short)
        '#If Win32 Then
        Dim stl As Integer
        Dim ll As Integer
        r = Space(maxlen)
        Call IEenter(r, maxlen, ll, addr, stl)
        l = ll
        r = Left(r, l)
        status = stl
        '#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
        'r = Space$(maxlen)
        'Call IEenter(r, maxlen, l, addr, status)
        'r = Left$(r, l)
        '#End If
    End Sub
    '-------------------------------------------------------
    Sub receive(ByRef r As String, ByRef maxlen As Short, ByRef l As Short, ByRef status As Short)
        '#If Win32 Then
        Dim stl As Integer
        Dim ll As Integer
        r = Space(maxlen)
        Call IEreceive(r, maxlen, ll, stl)
        l = ll
        r = Left(r, l)
        status = stl
        '#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
        'r = Space$(maxlen)
        'Call IEreceive(r, maxlen, l, status)
        'r = Left$(r, l)
        '#End If
    End Sub
    '-------------------------------------------------------
    Sub send(ByRef addr As Short, ByRef s As String, ByRef status As Short)
        '#If Win32 Then
        Dim stl As Integer
        Call IEsend(addr, s, -1, stl)
        status = stl
        '#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
        'Call IEsend(addr, s, -1, status)
        '#End If
    End Sub
    '-------------------------------------------------------
    Sub transmit(ByRef cmd As String, ByRef status As Short)
        '#If Win32 Then
        Dim stl As Integer
        Call IEtrans(cmd, -1, stl)
        status = stl
        '#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
        'Call IEtrans(cmd, -1, status)
        '#End If
    End Sub
    '-------------------------------------------------------
    Sub spoll(ByVal addr As Short, ByRef poll As Short, ByRef status As Short)
        '#If Win32 Then
        Dim stl As Integer
        Dim pl As Integer
        Call IEspoll(addr, pl, stl)
        poll = pl
        status = stl
        '#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
        'Call IEspoll(addr, poll, status)
        '#End If
    End Sub
    '-------------------------------------------------------
    Sub ppoll(ByRef poll As Short)
        '#If Win32 Then
        Dim pl As Integer
        Call IEppoll(pl)
        poll = pl
        '#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
        'Call IEppoll(poll)
        '#End If
    End Sub
    '-------------------------------------------------------
    ' IMPORTANT NOTE:
    '       To call tarray and rarray in VB 4, you must pass the
    '       entire array, as in:
    '               call tarray(d(),100,1,status%)
    '       You CANNOT pass d(1), as was done in previous versions
    '       of VB.  Microsoft changed the data types and argument
    '       conventions, so this source code change is required.
    '
    ' IMPORTANT NOTE: If you want to use arrays of a type other than
    '       integer, you must edit these procedures and change the
    '       type of the local array dd() in both tarray and rarray.
    '       Also, you must change the loop limit variable yy.
    '       For example, to use Byte arrays, change the dim statements to:
    '               dim dd(65535) as byte
    '       and the statement just before the "for xx" loops to:
    '               yy = count    
    '       and
    '               yy = l
    Sub tarray(ByRef d As Object, ByVal count As Integer, ByVal eoi As Short, ByRef status As Short)
        Dim xx As Object
        Dim yy As Object
        Dim dd(32767) As Short
#If Win32 Then
        Dim stl As Integer
        'UPGRADE_WARNING: Couldn't resolve default property of object yy. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
        If (count And 1) = 0 Then
            yy = count / 2
        Else
            'UPGRADE_WARNING: Couldn't resolve default property of object yy. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            yy = count / 2 + 1
        End If
        'UPGRADE_WARNING: Couldn't resolve default property of object yy. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
        For xx = 1 To yy
            'UPGRADE_WARNING: Couldn't resolve default property of object xx. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            'UPGRADE_WARNING: Couldn't resolve default property of object d(). Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            dd(xx) = d(xx) : Next xx
        '		Call IEtarray(dd(1), count, eoi, stl)
        status = stl
#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
		if (count and 1)=0 then yy=count/2 else yy=count/2+1
		For xx = 1 To yy: dd(xx) = d(xx): Next xx
        'Call IEtarray(dd(1), count, eoi, status)
#End If
    End Sub
    '-------------------------------------------------------
    ' IMPORTANT NOTE:
    '       To call tarray and rarray in VB 4, you must pass the
    '       entire array, as in:
    '               call tarray(d(),100,1,status%)
    '       You CANNOT pass d(1), as was done in previous versions
    '       of VB.  Microsoft changed the data types and argument
    '       conventions, so this source code change is required.
    '
    Sub rarray(ByRef d As Object, ByVal count As Integer, ByRef l As Short, ByRef status As Short)
        Dim xx As Object
        Dim yy As Object
        Dim dd(32767) As Short
#If Win32 Then
        Dim stl As Integer
        Dim ll As Integer
        '		Call IErarray(dd(1), count, ll, stl)
        l = ll
        status = stl
#Else
		'UPGRADE_NOTE: #If #EndIf block was not upgraded because the expression Else did not evaluate to True or was not evaluated. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1035"'
        '		Call IErarray(dd(1), count, l, status)
#End If
        'UPGRADE_WARNING: Couldn't resolve default property of object yy. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
        If (l And 1) = 0 Then
            yy = l / 2
        Else
            'UPGRADE_WARNING: Couldn't resolve default property of object yy. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            yy = l / 2 + 1
        End If
        'UPGRADE_WARNING: Couldn't resolve default property of object yy. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
        For xx = 1 To yy
            'UPGRADE_WARNING: Couldn't resolve default property of object xx. Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            'UPGRADE_WARNING: Couldn't resolve default property of object d(). Click for more: 'ms-help://MS.VSCC/commoner/redir/redirect.htm?keyword="vbup1037"'
            d(xx) = dd(xx) : Next xx
    End Sub
End Module